<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pay extends CI_Controller {

	public function __construct(){
      parent::__construct();
      $this->load->model('DB_Model');
      }

	public function index()
	{
		redirect('https://www.mandkstaffing.com/plans/');
	}

	public function secure($plan)
	{
		if(!$this->session->has_userdata('is_errors')){ $this->session->set_flashdata('is_errors',FALSE); $this->session->set_flashdata('error_messages','');}
		if ($plan == NULL)
		{
			redirect('https://www.mandkstaffing.com/plans/');
		}
		else{
			$data['page_title'] = 'Secure Gateway M & K Technovation';
        	$data['page_description'] = 'Secure Gateway M & K Technovation';
			$data['plan'] = $plan;
			$this->load->view('common/header',$data);
        	$this->load->view('pay_view',$data);
        	$this->load->view('common/footer');
		}
	}

	public function processtransaction()
	{
		$this->_transaction();
	}
	function _transaction()
	{
		$name = trim($this->input->post('cname'));
		$email = trim($this->input->post('cemail'));
		$plan = trim($this->input->post('plan'));
		$discount = trim($this->input->post('discount'));
		$grand_total = trim($this->input->post('grandtotal'));
		$employee_id = trim($this->input->post('eid'));
		$this->form_validation->set_rules('cname','Customer Name','trim|required');
		$this->form_validation->set_rules('cemail','Customer E-Mail','trim|required|valid_email');
		$this->form_validation->set_rules('eid','Employee ID','trim|required|numeric');
		if(trim($this->input->post('_order')) == 'order')
		{
			if ($this->form_validation->run() == FALSE)
            {
				$errors = '<div class="alert alert-danger alert-dismissible" role="alert"><button class="close" data-dismiss="alert" type="button" aria-label="Close"><i class="fa fa-times"></i></button>
			<span> Check Reuired Feilds</span></div>';
				$session_data = array('is_errors' => TRUE ,'error_messages' => $errors);
				$this->session->set_userdata($session_data);
				$url = 'pay/'.$plan;
				redirect(base_url($url));
			}else{

				$plan_price = $plan.'.99';
				$info = array('customer_name' => $name, 'customer_email' => $email,'plan' => $plan_price,'discount_percentage' => $discount,'transaction_amount' => $grand_total, 'employee_id' => $employee_id);
				$insert_data = $this->DB_Model->processTransaction($info);
				if($insert_data){
					echo 'Redirecting To Checkout Page';
					$checkout_url = 'pay/checkout/'.$this->url_encode($grand_total,'brar2009'); 
					redirect(base_url($checkout_url));
				}else{
					echo 'Redirection Failed';
				}
			}
		}else{
			redirect('https://www.mandkstaffing.com/plans/');
		}
	}

	public function checkout($price)
	{
		$data['page_title'] = 'Secure Gateway Checkout M & K Technovation';
        $data['page_description'] = 'Secure Gateway Checkout M & K Technovation';
		$data['grand_total'] = $this->url_decode($price,'brar2009');
		$this->load->view('common/header',$data);
        $this->load->view('checkout_view',$data);
        $this->load->view('common/footer');
	}

	function url_encode($string, $key = "", $url_safe = TRUE) {
    $ret = $this->encrypt->encode($string, $key);

    if ($url_safe) {
        $ret = strtr($ret, array('+' => '.', '=' => '-', '/' => '~'));
    }

    return $ret;
}

	function url_decode($string, $key = "") {
    $ret = strtr($string, array('.' => '+', '-' => '=', '~' => '/'));
    $ret1 = $this->encrypt->decode($ret, $key);
    return $ret1;
	}
}